<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Admin\Deposit;
use App\Models\Admin\Website;
use App\Models\TopDepositUserHeadline;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Carbon\Carbon;

use Illuminate\Support\Facades\DB;

class TopDepositUserHeadlineController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $top_users = Deposit::where('approval', 1)
            ->whereMonth('created_at', Carbon::now()->month)
            ->groupBy('user_id')
            ->select('user_id', DB::raw('SUM(amount) as total_amount'))
            ->orderBy('total_amount', 'desc')
            ->limit(10)
            ->get();
            
        $headlines = TopDepositUserHeadline::all();
        $website = Website::latest()->first();
        return view('backend.pages.system-setting.top-deposit-user-headline', compact('headlines', 'website', 'top_users'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
        ]);

        $data = new TopDepositUserHeadline();
        $data->title = Str::ucfirst($request->input('title'));
        $data->link = $request->input('link');
        $data->save();

        return redirect()->back()->with('message','Data added Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = TopDepositUserHeadline::find($id);
        $data->delete();

        return redirect()->back()->with('message','Data deleted Successfully');
    }
}
